#!/bin/bash
KAOS_DIR="$(cd "$(dirname "$0")" && pwd)"
PID_FILE="$KAOS_DIR/.kaos.pid"

if [[ ! -f "$PID_FILE" ]]; then
    echo "KAOS is not running (no PID file found)."
    read -p "Press Enter to close..."
    exit 0
fi

PID=$(cat "$PID_FILE")
if kill -0 "$PID" 2>/dev/null; then
    echo "Stopping KAOS (PID $PID)..."
    kill "$PID"
    sleep 1
    echo "KAOS stopped."
else
    echo "KAOS process not found — cleaning up stale PID file."
    rm -f "$PID_FILE"
fi
read -p "Press Enter to close..."
